function [A,B] = MarchingElem(XY,ELEM,V,isovalue)

NpE = cellfun(@numel,ELEM);
indT = find(NpE==3);
indQ = find(NpE==4);
indOTHER = setdiff(1:length(ELEM),union(indT,indQ));
if ~isempty(indOTHER)
    fprintf('MARCHINGELEM: Only trias and quads are supported.\n')
    fprintf('  The following elements will be ignored:\n')
    disp(indOTHER)
end
if ~isempty(intersect(indQ,indT))
    error('This should never happen...')
end

Tria = zeros(length(indT),3);
Quad = zeros(length(indQ),4);
for i=1:length(indT)
    Tria(i,:) = ELEM{indT(i)};
end
for i=1:length(indQ)
    Quad(i,:) = ELEM{indQ(i)};
end

[AT,BT] = MarchingTria(XY,Tria,V,isovalue);
[AQ,BQ] = MarchingQuads(XY,Quad,V,isovalue);

A = [AT;AQ];
B = [BT;BQ];

return 
